//
// (c) 2022 wesolutions GmbH
// All rights reserved
//

import QtQuick 2.12

import wesual.Ui 1.0

TextInput {
    id : edit

    property alias placeHolderText : placeHolder.text

    readonly property bool empty : text.length <= 0
    readonly property bool hovered : mouseArea.containsMouse

    clip : true
    leftPadding : 6
    rightPadding : 6
    topPadding : 4
    bottomPadding : 4
    color : enabled
            ? UiColors.getColor(UiColors.DarkGrey80)
            : UiColors.getColor(UiColors.MediumLightGrey27)

    activeFocusOnTab  : true
    selectByMouse     : true
    selectionColor    : UiColors.getColor(UiColors.SelectionGreen)
    selectedTextColor : UiColors.getColor(UiColors.White)

    font : UiFonts.getFont(UiFonts.Light, 14)

    Text {
        id : placeHolder

        leftPadding : edit.leftPadding
        rightPadding : edit.rightPadding
        topPadding : edit.topPadding
        bottomPadding : edit.bottomPadding
        visible : edit.empty
        color : edit.enabled
                ? UiColors.getColor(UiColors.MediumGrey33)
                : UiColors.getColor(UiColors.DisabledLightGrey13)
        wrapMode : Text.NoWrap
        elide : Qt.ElideRight

        font : edit.font

        anchors.fill : edit
    }

    MouseArea {
        id : mouseArea

        acceptedButtons : Qt.NoButton
        anchors.fill : edit
        cursorShape : Qt.IBeamCursor
        hoverEnabled : true
    }

    Rectangle {
        id : background

        anchors.fill : edit
        color : UiColors.getColor(UiColors.White)
        border {
            width : 1
            color : {
                if (!edit.enabled) {
                    return UiColors.getColor(UiColors.DisabledLightGrey13);
                } else if (edit.activeFocus) {
                    return UiColors.getColor(UiColors.SelectionGreen);
                } else if (mouseArea.containsMouse) {
                    return UiColors.getColor(UiColors.HoverGreen);
                } else {
                    return UiColors.getColor(UiColors.ControlGrey20);
                }
            }
        }
        z : -1
    }

    UiTextContextMenu {
        textEditor : edit

        onContextMenuRequested : edit.forceActiveFocus()
    }
}
